{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:12:12 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Buttons,
  MMSystem,
  MMObj,
  MMUtils,
  MMSlider,
  MMHTimer,
  MMDSPMtr,
  MMWavOut,
  MMRingBf,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMDesign,
  MMLevel,
  MMLEDS,
  MMDIBCv,
  MMSpectr,
  MMVolume,
  MMWheel,
  MMEdit,
  MMPhase, MMHook;

type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    MMWaveIn: TMMWaveIn;
    MMConnector1: TMMConnector;
    MMRingBuffer1: TMMRingBuffer;
    MMWaveOut1: TMMWaveOut;
    DSPMeter: TMMDSPMeter;
    MMHiTimer1: TMMHiTimer;
    Panel4: TPanel;
    Panel8: TPanel;
    Label4: TLabel;
    DSPLabel: TLabel;
    StartBtn: TButton;
    StopBtn: TButton;
    Panel7: TPanel;
    lblDelay: TLabel;
    sliderDelay: TMMSlider;
    edDelay: TMMNumberEdit;
    Spectrum2: TMMSpectrum;
    Phaser: TMMPhaser;
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMHiTimer1Timer(Sender: TObject);
    procedure MMWaveInStart(Sender: TObject);
    procedure MMWaveInStop(Sender: TObject);
    procedure edExit(Sender: TObject);
    procedure sliderDelayTrackEnd(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { stop and close the device }
   MMWaveIn.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
   { is the current device a Full-Duplex device ? }
   if not DeviceFullDuplex(MMWaveIn.DeviceID,MMWaveIn.PWaveFormat) then
   begin
      MessageDlg('You need a "Full-Duplex" device to run this demo', mtError, [mbOK], 0);
      StopBtn.Enabled := False;
      StartBtn.Enabled := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.StartBtnClick(Sender: TObject);
begin
   { open and start the device }
   MMWaveIn.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.StopBtnClick(Sender: TObject);
begin
   { stop and close the device }
   MMWaveIn.Close;

   DSPLabel.Caption := '0 %';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.MMHiTimer1Timer(Sender: TObject);
begin
   DSPLabel.Caption := IntToStr(DSPMeter.Value)+ ' %';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.MMWaveInStart(Sender: TObject);
begin
   MMHiTimer1.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.MMWaveInStop(Sender: TObject);
begin
   MMHiTimer1.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.sliderDelayTrackEnd(Sender: TObject);
begin
   edDelay.Value := SliderDelay.Position;
   Phaser.Delay  := SliderDelay.Position;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.edExit(Sender: TObject);
begin
   SliderDelay.Position  := edDelay.Value;
end;

end.
